using System;

interface IShow
{
  void Show();
}

public abstract class Shape
{
  public int color;
  public virtual void Show()
  {
    Console.WriteLine("Metoda Show klasy bazowej");
  }
}

public class Rectangle : Shape, IShow
{
  public int x;
  public int y;
  public int width;
  public int height;
  public Rectangle(int x, int y, int width, int height)
  {
    this.x = x;
    this.y = y;
    this.width = width;
    this.height = height;
  }
  public override void Show()
  {
    Console.WriteLine("Parametry prostokąta:");
    Console.WriteLine("współrzędna x = {0}", x);
    Console.WriteLine("współrzędna y = {0}", y);
    Console.WriteLine("długość = {0}", width);
    Console.WriteLine("szerokość = {0}\n", height);
  }
}

public class Triangle : Shape, IShow
{
  public Point a;
  public Point b;
  public Point c;
  public Triangle(Point a, Point b, Point c)
  {
    this.a = a;
    this.b = b;
    this.c = c;
  }
  public override void Show()
  {
    Console.WriteLine("Parametry trójkąta:");
    Console.WriteLine("punkt a = ({0}, {1})", a.x, a.y);
    Console.WriteLine("punkt b = ({0}, {1})", b.x, b.y);
    Console.WriteLine("punkt c = ({0}, {1})\n", c.x, c.y);
  }
}

public class Point : Shape
{
  public int x;
  public int y;
  public Point(int x, int y)
  {
    this.x = x;
    this.y = y;
  }
}
